// config: norepeat noautolaunch

#include "GetObjects.js"
#include "WaitForDialogDone.js"

function DoRebuild()
{
	var ui = moi.ui;

	var objectpicker = ui.createObjectPicker();
	objectpicker.allowCurves();
	if ( !GetObjects( objectpicker ) )
		return;
		
	ui.beginUIUpdate();
	ui.hideUI( 'SelectObjectsPrompt' );
	ui.showUI( 'OptionsPrompt' );
	ui.showUI( 'RebuildOptions' );
	ui.endUIUpdate();

	var factory = moi.command.createFactory( 'rebuildcurve' );

	factory.setInput( 0, objectpicker.objects );
	
	factory.disableUpdate( true );
	ui.bindUIToInput( 'mode', 'value', factory.getInput(1) );
	ui.bindUIToInput( 'tol', 'value', factory.getInput(2) );
	ui.bindUIToInput( 'numpoints', 'value', factory.getInput(3) );
	ui.bindUIToInput( 'delete', 'value', factory.getInput(4) );
	ui.bindUIToInput( 'keepcorners', 'value', factory.getInput(5) );
	ui.bindUIToInput( 'breakangle', 'value', factory.getInput(6) );
	factory.disableUpdate( false );
	factory.update();

	if ( !WaitForDialogDone() )
		return;
	
	factory.commit();
}

DoRebuild();
